#ifndef _GST_TYPES_H_
#define _GST_TYPES_H_

#include <boost/cstdint.hpp>

namespace GST
{
namespace GSTCore
{
struct GSTbox
{
	double xmin, xmax, ymin, ymax, zmin, zmax;

	GSTbox(double _xmin = 0.0,
		   double _xmax = 0.0,
		   double _ymin = 0.0,
		   double _ymax = 0.0,
		   double _zmin = 0.0,
		   double _zmax = 0.0)
		: xmin(_xmin)
		, xmax(_xmax)
		, ymin(_ymin)
		, ymax(_ymax)
		, zmin(_zmin)
		, zmax(_zmax)
	{
	}

	GSTbox(const GSTbox &box)
	{
		if(&box != this)
		{
			this->xmin = box.xmin;
			this->ymin = box.ymin;
			this->zmin = box.zmin;

			this->xmax = box.xmax;
			this->ymax = box.ymax;
			this->zmax = box.zmax;
		}
	}
};

bool isLittleEndian();
uint16_t swapEndian(uint16_t);
uint32_t swapEndian(uint32_t);
uint64_t swapEndian(uint64_t);
uint32_t swapEndian(float);
uint64_t swapEndian(double);
} // namespace GSTCore
} // namespace GST
#endif
